/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.CtrEncriptar;
import controller.CtrHttpApi;
import controller.FXMLSesionController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import model.mdl_Actividad;
import model.mdl_Genero;
import model.mdl_Motivo;
import model.mdl_TipoDocumento;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FXMLLoginController
implements Initializable {
    @FXML
    private HBox hbxFormulario;
    @FXML
    private HBox hbxLogos;
    @FXML
    private AnchorPane apnLogin;
    @FXML
    private Pane pnlLogin;
    @FXML
    private Pane pnlRegistro;
    @FXML
    private Button btnCerrar;
    @FXML
    private TextField txtDocumentoLogin;
    @FXML
    private PasswordField txtContrasenaLogin;
    @FXML
    private ComboBox cboMotivo;
    @FXML
    private TextArea txaTematica;
    @FXML
    private ComboBox cboActividad;
    @FXML
    private Button btnIngresar;
    @FXML
    private Button btnAbrirRegistro;
    @FXML
    private HBox hbxEsperaLogin;
    @FXML
    private HBox hbxMensajeLogin;
    @FXML
    private Label lblMensajeLogin;
    @FXML
    private ComboBox cboTipoDocumento;
    @FXML
    private TextField txtDocumento;
    @FXML
    private TextField txtDocumentoValidar;
    @FXML
    private TextField txtNombre;
    @FXML
    private TextField txtApellido;
    @FXML
    private DatePicker dtpFechaNacimiento;
    @FXML
    private ComboBox cboGenero;
    @FXML
    private TextField txtBarrio;
    @FXML
    private TextField txtTelefono;
    @FXML
    private TextField txtOcupacion;
    @FXML
    private TextField txtCorreo;
    @FXML
    private PasswordField txtContrasena;
    @FXML
    private PasswordField txtContrasenaValidar;
    @FXML
    private CheckBox chbTratamiento;
    @FXML
    private Button btnRegistrarse;
    @FXML
    private Button btnAbrirLogin;
    @FXML
    private HBox hbxEspera;
    @FXML
    private HBox hbxMensajeRegistro;
    @FXML
    private Label lblMensajeRegistro;
    private int idTelecentro;
    private String nombrePuesto;
    private String contrasenaMaster;
    private Screen screen;
    private CtrHttpApi api;
    private JSONParser parser;
    private JSONArray arrayMotivos;
    private JSONArray arrayTipoDocumento;
    private JSONArray arrayGenero;
    private JSONArray arrayActividades;
    private ObservableList<mdl_Motivo> listaMotivos;
    private ObservableList<mdl_TipoDocumento> listaTiposDocumento;
    private ObservableList<mdl_Genero> listaGenero;
    private ObservableList<mdl_Actividad> listaActividades;
    private Pattern pattern;
    private Thread thread;
    private boolean correrHilo = true;
    private int segundosOcultarFormularios = 0;
    private final int segundosEspera = 30;

    public void initialize(URL url, ResourceBundle rb) {
        this.cargarConfiguracionTelecentro();
        this.api = new CtrHttpApi();
        this.parser = new JSONParser();
        this.pattern = this.pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        this.screen = Screen.getPrimary();
        Rectangle2D bounds = this.screen.getVisualBounds();
        this.hbxLogos.setPrefSize(bounds.getWidth(), bounds.getHeight());
        this.hbxLogos.setAlignment(Pos.CENTER);
        this.hbxFormulario.setPrefSize(bounds.getWidth(), bounds.getHeight());
        this.hbxFormulario.setAlignment(Pos.CENTER);
        this.hbxLogos.setVisible(true);
        this.hbxLogos.setManaged(true);
        this.hbxFormulario.setVisible(false);
        this.hbxFormulario.setManaged(false);
        this.apnLogin.addEventFilter(MouseEvent.MOUSE_MOVED, event -> {
            this.segundosOcultarFormularios = 0;
        });
        this.apnLogin.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            this.segundosOcultarFormularios = 0;
        });
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Runnable updater = new Runnable(){

                    @Override
                    public void run() {
                        FXMLLoginController.this.mostrarOcultarFormulario();
                    }
                };
                while (FXMLLoginController.this.correrHilo) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Platform.runLater((Runnable)updater);
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
        this.pnlLogin.setVisible(true);
        this.pnlLogin.setManaged(true);
        this.pnlRegistro.setVisible(false);
        this.pnlRegistro.setManaged(false);
        this.txaTematica.setVisible(true);
        this.txaTematica.setManaged(true);
        this.cboActividad.setVisible(false);
        this.cboActividad.setManaged(false);
        this.hbxEsperaLogin.setVisible(false);
        this.hbxEsperaLogin.setManaged(false);
        this.hbxMensajeLogin.setVisible(false);
        this.hbxMensajeLogin.setManaged(false);
        this.hbxEspera.setVisible(false);
        this.hbxEspera.setManaged(false);
        this.hbxMensajeRegistro.setVisible(false);
        this.hbxMensajeRegistro.setManaged(false);
        this.listaTiposDocumento = FXCollections.observableArrayList();
        this.listaMotivos = FXCollections.observableArrayList();
        this.listaGenero = FXCollections.observableArrayList();
        this.listaActividades = FXCollections.observableArrayList();
        this.listaTiposDocumento.add((Object)new mdl_TipoDocumento(0, "TIPO DE DOCUMENTO", "NA"));
        this.listaMotivos.add((Object)new mdl_Motivo(0, "INGRESE EL MOTIVO"));
        this.listaGenero.add((Object)new mdl_Genero(0, "G\u00c9NERO", 'N'));
        this.listaGenero.add((Object)new mdl_Genero(1, "MASCULINO", 'M'));
        this.listaGenero.add((Object)new mdl_Genero(2, "FEMENINO", 'F'));
        this.listaGenero.add((Object)new mdl_Genero(3, "OTRO", 'O'));
        this.listaActividades.add((Object)new mdl_Actividad(0, "SELECCIONE LA TEM\u00c1TICA"));
        this.cboActividad.setItems(this.listaActividades);
        this.cboActividad.getSelectionModel().selectFirst();
        this.dtpFechaNacimiento.setConverter((StringConverter)new StringConverter<LocalDate>(){
            private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-dd-MM");

            public String toString(LocalDate localDate) {
                if (localDate == null) {
                    return "";
                }
                return this.dateTimeFormatter.format(localDate);
            }

            public LocalDate fromString(String dateString) {
                if (dateString == null || dateString.trim().isEmpty()) {
                    return null;
                }
                return LocalDate.parse(dateString, this.dateTimeFormatter);
            }
        });
        try {
            this.arrayTipoDocumento = (JSONArray)((JSONObject)this.parser.parse(this.api.consulta("tiposDocumento", "{}"))).get((Object)"respuesta");
            this.arrayMotivos = (JSONArray)((JSONObject)this.parser.parse(this.api.consulta("motivos", "{}"))).get((Object)"respuesta");
            for (Object obj : this.arrayTipoDocumento) {
                JSONObject tipo = (JSONObject)obj;
                this.listaTiposDocumento.add((Object)new mdl_TipoDocumento(Integer.parseInt(tipo.get((Object)"TIP_TipoDocumento").toString()), tipo.get((Object)"TIP_Nombre").toString(), tipo.get((Object)"TIP_Sigla").toString()));
            }
            for (Object obj : this.arrayMotivos) {
                JSONObject motivo = (JSONObject)obj;
                this.listaMotivos.add((Object)new mdl_Motivo(Integer.parseInt(motivo.get((Object)"MOT_Motivo").toString()), motivo.get((Object)"MOT_Nombre").toString()));
            }
            this.cboTipoDocumento.setItems(this.listaTiposDocumento);
            this.cboTipoDocumento.getSelectionModel().selectFirst();
            this.cboMotivo.setItems(this.listaMotivos);
            this.cboMotivo.getSelectionModel().selectFirst();
            this.cboMotivo.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
                if (newVal != null) {
                    String seleccion = ((mdl_Motivo)this.cboMotivo.getValue()).getNombre();
                    this.cboActividad.getSelectionModel().selectFirst();
                    if (seleccion.equalsIgnoreCase("Taller") || seleccion.equalsIgnoreCase("Capacitaci\u00f3n")) {
                        String json = "{\"idTelecentro\": \"" + this.idTelecentro + "\"}";
                        try {
                            JSONObject consulta = (JSONObject)this.parser.parse(this.api.consulta("getActividades", json));
                            JSONObject respuesta = (JSONObject)consulta.get((Object)"respuesta");
                            this.arrayActividades = (JSONArray)respuesta.get((Object)"Talleres");
                            this.cboActividad.getItems().clear();
                            switch (seleccion) {
                                case "Talleres": {
                                    this.arrayActividades = (JSONArray)respuesta.get((Object)"Talleres");
                                    break;
                                }
                                case "Capacitaci\u00f3n": {
                                    this.arrayActividades = (JSONArray)respuesta.get((Object)"Capacitaciones");
                                }
                            }
                            this.listaActividades.add((Object)new mdl_Actividad(0, "SELECCIONE LA TEM\u00c1TICA"));
                            for (Object obj : this.arrayActividades) {
                                JSONObject actividad = (JSONObject)obj;
                                this.listaActividades.add((Object)new mdl_Actividad(Integer.parseInt(actividad.get((Object)"ACT_Actividad").toString()), actividad.get((Object)"ACT_Tematica").toString()));
                            }
                            this.cboActividad.getSelectionModel().selectFirst();
                            this.cboActividad.setItems(this.listaActividades);
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(FXMLLoginController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.txaTematica.setVisible(false);
                        this.txaTematica.setManaged(false);
                        this.cboActividad.setVisible(true);
                        this.cboActividad.setManaged(true);
                    } else {
                        this.txaTematica.setVisible(true);
                        this.txaTematica.setManaged(true);
                        this.cboActividad.setVisible(false);
                        this.cboActividad.setManaged(false);
                    }
                }
            });
            this.cboGenero.setItems(this.listaGenero);
            this.cboGenero.getSelectionModel().selectFirst();
        }
        catch (ParseException ex) {
            Logger.getLogger(FXMLLoginController.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println(ex.getCause());
        }
        this.txtDocumento.addEventHandler(KeyEvent.KEY_TYPED, event -> this.SoloNumerosEnteros((KeyEvent)event));
        this.txtDocumentoLogin.addEventHandler(KeyEvent.KEY_TYPED, event -> this.SoloNumerosEnteros((KeyEvent)event));
        this.txtDocumentoValidar.addEventHandler(KeyEvent.KEY_TYPED, event -> this.SoloNumerosEnteros((KeyEvent)event));
        this.txtTelefono.addEventHandler(KeyEvent.KEY_TYPED, event -> this.SoloNumerosEnteros((KeyEvent)event));
        this.btnCerrar.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLLoginController.this.cerrarVentana();
                event.consume();
            }
        });
        this.btnAbrirLogin.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLLoginController.this.abrirLogin();
                event.consume();
            }
        });
        this.btnAbrirRegistro.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLLoginController.this.abrirRegistro();
                event.consume();
            }
        });
        this.btnIngresar.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLLoginController.this.ingresar(event);
                event.consume();
            }
        });
        this.btnAbrirRegistro.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLLoginController.this.abrirRegistro();
                event.consume();
            }
        });
        this.btnRegistrarse.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXMLLoginController.this.registrarse();
                event.consume();
            }
        });
    }

    private void cargarConfiguracionTelecentro() {
        try (BufferedReader reader = new BufferedReader(new FileReader(new File("telecentro.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] config = CtrEncriptar.desencriptar(line).split("\\|");
                this.idTelecentro = Integer.parseInt(config[0]);
                this.nombrePuesto = config[1];
                this.contrasenaMaster = config[2];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mostrarOcultarFormulario() {
        ++this.segundosOcultarFormularios;
        if (this.segundosOcultarFormularios >= this.segundosEspera) {
            this.hbxLogos.setVisible(true);
            this.hbxLogos.setManaged(true);
            this.hbxFormulario.setVisible(false);
            this.hbxFormulario.setManaged(false);
        } else {
            this.hbxLogos.setVisible(false);
            this.hbxLogos.setManaged(false);
            this.hbxFormulario.setVisible(true);
            this.hbxFormulario.setManaged(true);
        }
    }

    private void abrirLogin() {
        this.pnlLogin.setVisible(true);
        this.pnlLogin.setManaged(true);
        this.pnlRegistro.setVisible(false);
        this.pnlRegistro.setManaged(false);
        this.txtDocumentoLogin.setText("");
        this.txtContrasenaLogin.setText("");
        this.cboMotivo.getSelectionModel().selectFirst();
        this.cboActividad.getSelectionModel().selectFirst();
        this.txaTematica.setText("");
        this.hbxMensajeLogin.setVisible(false);
        this.lblMensajeLogin.setText("");
    }

    private void abrirRegistro() {
        this.pnlLogin.setVisible(false);
        this.pnlLogin.setManaged(false);
        this.pnlRegistro.setVisible(true);
        this.pnlRegistro.setManaged(true);
        this.cboTipoDocumento.getSelectionModel().selectFirst();
        this.cboGenero.getSelectionModel().selectFirst();
        this.txtDocumento.setText("");
        this.txtDocumentoValidar.setText("");
        this.txtNombre.setText("");
        this.txtApellido.setText("");
        this.dtpFechaNacimiento.getEditor().clear();
        this.txtBarrio.setText("");
        this.txtTelefono.setText("");
        this.txtOcupacion.setText("");
        this.txtCorreo.setText("");
        this.txtContrasena.setText("");
        this.txtContrasenaValidar.setText("");
        this.chbTratamiento.setSelected(false);
        this.hbxMensajeRegistro.setVisible(false);
        this.lblMensajeRegistro.setText("");
    }

    private void ingresar(ActionEvent event) {
        int idActividad;
        String tematica;
        this.hbxEsperaLogin.setVisible(true);
        this.hbxEsperaLogin.setManaged(true);
        String documento = this.txtDocumentoLogin.getText();
        String contrasena = this.txtContrasenaLogin.getText().trim();
        int motivo = ((mdl_Motivo)this.cboMotivo.getValue()).getId();
        mdl_Actividad actividad = (mdl_Actividad)this.cboActividad.getValue();
        if (actividad.getId() == 0) {
            tematica = this.txaTematica.getText().trim();
            idActividad = -1;
        } else {
            tematica = actividad.getNombre();
            idActividad = actividad.getId();
        }
        if (documento.isEmpty() || contrasena.isEmpty() || motivo == 0 || tematica.isEmpty()) {
            this.mensajeLogin("Debe completar los campos!!!");
        } else {
            String json = "{\"telecentro\": \"" + this.idTelecentro + "\",\"documento\": \"" + documento.trim() + "\",\"nombrePuesto\": \"" + this.nombrePuesto + "\",\"contrasena\": \"" + contrasena.trim() + "\",\"motivo\": \"" + motivo + "\",\"tematica\": \"" + tematica.trim() + "\",\"idActividad\": \"" + idActividad + "\"}";
            try {
                JSONObject consulta = (JSONObject)this.parser.parse(this.api.consulta("login", json));
                String status = consulta.get((Object)"status").toString();
                String respuesta = consulta.get((Object)"respuesta").toString();
                if (status.equals("200")) {
                    if (!respuesta.equals("false")) {
                        this.abrirEquipo(event, Long.parseLong(respuesta));
                    } else {
                        this.mensajeLogin("Datos incorrectos!!!");
                    }
                } else {
                    this.mensajeLogin("Se ha producido un error");
                }
            }
            catch (ParseException ex) {
                this.mensajeLogin("Se ha producido un error");
            }
        }
    }

    private void mensajeLogin(String mensaje) {
        this.hbxEsperaLogin.setVisible(false);
        this.hbxEsperaLogin.setManaged(false);
        this.hbxMensajeLogin.setVisible(true);
        this.hbxMensajeLogin.setManaged(true);
        this.lblMensajeLogin.setText(mensaje);
    }

    private void cerrarVentana() {
        JFrame jf = new JFrame();
        jf.setAlwaysOnTop(true);
        String contrasena = JOptionPane.showInputDialog(jf, (Object)"Ingrese la contrase\u00f1a para salir");
        if (contrasena != null && !contrasena.isEmpty()) {
            if (this.contrasenaMaster.equals(contrasena)) {
                JOptionPane.showMessageDialog(jf, "Hasta luego!!!");
                System.exit(0);
            } else {
                JOptionPane.showMessageDialog(jf, "No tiene permisos para realizar esta acci\u00f3n!!!");
            }
        }
    }

    private void abrirEquipo(ActionEvent event, long idUso) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/xml/FXMLSesion.fxml"));
            Parent root = (Parent)loader.load();
            FXMLSesionController controlador = (FXMLSesionController)loader.getController();
            controlador.setIdUso(idUso);
            Scene scene = new Scene(root);
            Stage stage = new Stage();
            stage.toFront();
            Screen screen = Screen.getPrimary();
            Rectangle2D bounds = screen.getVisualBounds();
            stage.setX(bounds.getMinX());
            stage.setY(bounds.getMinY());
            stage.setOnCloseRequest(e -> e.consume());
            stage.setAlwaysOnTop(true);
            stage.setResizable(false);
            stage.setScene(scene);
            stage.show();
            Node source = (Node)event.getSource();
            Stage stagePrincipal = (Stage)source.getScene().getWindow();
            this.correrHilo = false;
            stagePrincipal.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FXMLLoginController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void registrarse() {
        this.hbxMensajeRegistro.setVisible(false);
        this.lblMensajeRegistro.setText("");
        this.hbxMensajeRegistro.setManaged(false);
        this.hbxEspera.setVisible(true);
        this.hbxEspera.setManaged(true);
        int tipoDocumento = ((mdl_TipoDocumento)this.cboTipoDocumento.getValue()).getId();
        String documento = this.txtDocumento.getText().trim();
        String documentoValidar = this.txtDocumentoValidar.getText().trim();
        String nombre = this.txtNombre.getText().trim();
        String apellido = this.txtApellido.getText().trim();
        LocalDate fechaNacimiento = (LocalDate)this.dtpFechaNacimiento.getValue();
        char genero = ((mdl_Genero)this.cboGenero.getValue()).getSigla();
        String barrio = this.txtBarrio.getText().trim();
        long telefono = Long.parseLong(this.txtTelefono.getText().trim().isEmpty() ? "0" : this.txtTelefono.getText().trim());
        String ocupacion = this.txtOcupacion.getText().trim();
        String correo = this.txtCorreo.getText().trim();
        Matcher validarCorreo = this.pattern.matcher(correo);
        String contrasena = this.txtContrasena.getText().trim();
        String contrasenaValidar = this.txtContrasenaValidar.getText().trim();
        boolean tratamiento = this.chbTratamiento.isSelected();
        if (tipoDocumento == 0) {
            this.mensajeRegistro("Debe seleccionar el tipo de documento!!!");
            return;
        }
        if (genero == 'N') {
            this.mensajeRegistro("Debe seleccionar un g\u00e9nero!!!");
            return;
        }
        if (documento.isEmpty() || documentoValidar.isEmpty() || nombre.isEmpty() || apellido.isEmpty() || fechaNacimiento == null || barrio.isEmpty() || ocupacion.isEmpty() || correo.isEmpty() || contrasena.isEmpty() || contrasenaValidar.isEmpty()) {
            this.mensajeRegistro("Debe completar todos los campos requeridos!!!");
            return;
        }
        if (!validarCorreo.find()) {
            this.mensajeRegistro("Debe ingresar un direcci\u00f3n de correo electr\u00f3nico v\u00e1lida!!!");
            return;
        }
        if (!documento.equalsIgnoreCase(documentoValidar)) {
            this.mensajeRegistro("Los documentos no coinciden!!!");
            return;
        }
        if (!contrasena.equals(contrasenaValidar)) {
            this.mensajeRegistro("Las contrase\u00f1as no coinciden!!!");
            return;
        }
        if (!tratamiento) {
            this.mensajeRegistro("Para registrarse debe aprobar el tratamiento de sus datos personales!!!");
            return;
        }
        String json = "{\"tipoDocumento\": \"" + tipoDocumento + "\",\"documento\": \"" + documento + "\",\"nombre\": \"" + nombre + "\",\"apellido\": \"" + apellido + "\",\"fechaNacimiento\": \"" + fechaNacimiento + "\",\"genero\": \"" + genero + "\",\"barrio\": \"" + barrio + "\",\"telefono\": \"" + telefono + "\",\"ocupacion\": \"" + ocupacion + "\",\"correo\": \"" + correo + "\",\"contrasena\": \"" + contrasena + "\",\"tratamientoDatos\": \"" + tratamiento + "\"}";
        try {
            JSONObject consulta = (JSONObject)this.parser.parse(this.api.consulta("registro", json));
            String status = consulta.get((Object)"status").toString();
            String respuesta = consulta.get((Object)"respuesta").toString();
            if (status.equals("200")) {
                if (respuesta.equals("true")) {
                    this.mensajeRegistro("Usuario registrado correctamente");
                } else {
                    this.mensajeRegistro(respuesta);
                }
            } else {
                this.mensajeRegistro("No se ha podido ingresar el usuario");
            }
        }
        catch (ParseException ex) {
            this.mensajeRegistro("No se ha podido ingresar el usuario");
        }
    }

    private void mensajeRegistro(String mensaje) {
        this.hbxMensajeRegistro.setVisible(true);
        this.hbxMensajeRegistro.setManaged(true);
        this.lblMensajeRegistro.setText(mensaje);
        this.hbxEspera.setVisible(false);
        this.hbxEspera.setManaged(false);
    }

    public void SoloNumerosEnteros(KeyEvent keyEvent) {
        try {
            char key = keyEvent.getCharacter().charAt(0);
            if (!Character.isDigit(key)) {
                keyEvent.consume();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

